/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.badge;

import io.github.thecsdev.tcdcommons.TCDCommons;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_2960;

public class PlayerBadgeHandler
implements ObjectIterable<Object2IntMap.Entry<class_2960>> {
    public static final class_2960 PBH_CUSTOM_DATA_ID = new class_2960(TCDCommons.getModID(), "player_badges");
    protected final Object2IntMap<class_2960> statMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public PlayerBadgeHandler() {
        this.statMap.defaultReturnValue(0);
    }

    public final ObjectIterator<Object2IntMap.Entry<class_2960>> iterator() {
        return this.statMap.object2IntEntrySet().iterator();
    }

    public final int getValue(class_2960 badgeId) {
        return this.statMap.getInt((Object)badgeId);
    }

    public void setValue(class_2960 badgeId, int value) throws NullPointerException {
        if (value < 1) {
            this.statMap.removeInt((Object)badgeId);
        } else {
            this.statMap.put((Object)Objects.requireNonNull(badgeId), value);
        }
    }

    public final void increaseValue(class_2960 badgeId, int by) {
        int i = (int)Math.min((long)this.getValue(badgeId) + (long)by, Integer.MAX_VALUE);
        this.setValue(badgeId, i);
    }

    public final void clearBadges() {
        HashSet keys = new HashSet(this.statMap.keySet());
        for (class_2960 key : keys) {
            this.setValue(key, 0);
        }
        this.statMap.clear();
    }

    public static final Map<String, List<class_2960>> toMapByModId(Iterable<class_2960> badgeIDs) {
        return StreamSupport.stream(badgeIDs.spliterator(), false).collect(Collectors.groupingBy(class_2960::method_12836, HashMap::new, Collectors.toList()));
    }
}

